<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Plugin\Model\CatalogInventory;

use Magento\CatalogInventory\Api\Data\StockItemInterface;

class StockStateProvider
{
    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Data
     */
    private $helper;

    /**
     * Constructor
     *
     * @param \Webkul\AdvancedBookingSystem\Helper\Data $helper
     */
    public function __construct(
        \Webkul\AdvancedBookingSystem\Helper\Data $helper
    ) {
        $this->helper = $helper;
    }

    /**
     * After getCheckQty
     *
     * @param \Magento\CatalogInventory\Model\StockStateProvider $subject
     * @param mixed $result
     * @param StockItemInterface $stockItem
     */
    public function afterCheckQty(
        \Magento\CatalogInventory\Model\StockStateProvider $subject,
        $result,
        StockItemInterface $stockItem
    ) {
        try {
            if ($result == false) {
                $helper = $this->helper;
                $product = $helper->getProduct($stockItem->getProductId());
                $productSetId = $product->getAttributeSetId();
                $hotelAttrSetId = $helper->getProductAttributeSetIdByLabel(
                    'Hotel Booking'
                );
                if (($product->getTypeId() == "virtual" || $product->getTypeId()=="hotelbooking")
                    && $productSetId==$hotelAttrSetId
                ) {
                    return true;
                }
            }
        } catch (\Exception $e) {
            $this->helper->logDataInLogger(
                "Plugin_Model_CatalogInventory_StockStateProvider_afterCheckQty Exception : ".$e->getMessage()
            );
        }
        return $result;
    }
}
