<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Plugin\Pricing\Price;

class FinalPrice
{
    /** @var \Webkul\AdvancedBookingSystem\Helper\Data */
    protected $helper;
    
    /** @var \Magento\Framework\App\Request\Http */
    protected $request;

    /**
     * Constructor
     *
     * @param \Webkul\AdvancedBookingSystem\Helper\Data $helper
     * @param \Magento\Framework\App\Request\Http $request
     */
    public function __construct(
        \Webkul\AdvancedBookingSystem\Helper\Data $helper,
        \Magento\Framework\App\Request\Http $request
    ) {
        $this->helper = $helper;
        $this->request = $request;
    }

    /**
     * After getValue
     *
     * @param \Magento\Catalog\Pricing\Price\FinalPrice $subject
     * @param mixed $result
     */
    public function afterGetValue(
        \Magento\Catalog\Pricing\Price\FinalPrice $subject,
        $result
    ) {
        $route = $this->request->getFullActionName();
        if ($route == "catalog_category_view") {
            $product = $subject->getProduct();
            $productSetId = $product->getAttributeSetId();
            $rentalAttrSetId = $this->helper->getProductAttributeSetIdByLabel(
                'Rental Booking'
            );
            if ($productSetId == $rentalAttrSetId) {
                $rentOptions = $this->helper->getRentOptions($product);
                if (!empty($rentOptions['choose_rent_type']['option_id'])) {
                    $optionId = $rentOptions['choose_rent_type']['option_id'];
                    $optionValues = $rentOptions['choose_rent_type']['option_values'];
                    if ($optionId && !empty($optionValues)) {
                        $priceByStore = 0;
                        foreach ($optionValues as $key => $value) {
                            $priceByStore = $this->helper->currencyByStore(
                                $value['price'],
                                $product->getStore(),
                                false
                            );
                        }
                        $result += $priceByStore;
                    }
                }
            }
        }
        return $result;
    }
}
