<?php
/**
 * Webkul Software.
 *
 * @category  Webkul
 * @package   Webkul_AdvancedBookingSystem
 * @author    Webkul Software Private Limited
 * @copyright Webkul Software Private Limited (https://webkul.com)
 * @license   https://store.webkul.com/license.html
 */
namespace Webkul\AdvancedBookingSystem\Plugin\Ui\DataProvider\Product\Form\Modifier;

use Magento\Catalog\Ui\DataProvider\Product\Form\Modifier\AttributeSet as ModifierAttributeSet;
use Magento\Eav\Model\ResourceModel\Entity\Attribute\Set\CollectionFactory;

class AttributeSet
{
    /**
     * Set collection factory
     *
     * @var CollectionFactory
     */
    private $attributeSetCollectionFactory;

    /**
     * @var \Magento\Framework\UrlInterface
     */
    private $urlBuilder;

    /**
     * @var \Magento\Catalog\Model\Locator\LocatorInterface
     */
    private $locator;

    /**
     * @var \Webkul\AdvancedBookingSystem\Helper\Data
     */
    private $helperData;

    /**
     * Constructor
     *
     * @param \Magento\Catalog\Model\Locator\LocatorInterface $locator
     * @param CollectionFactory                               $attributeSetCollectionFactory
     * @param \Magento\Framework\UrlInterface                 $urlBuilder
     * @param \Webkul\AdvancedBookingSystem\Helper\Data       $helperData
     */
    public function __construct(
        \Magento\Catalog\Model\Locator\LocatorInterface $locator,
        CollectionFactory $attributeSetCollectionFactory,
        \Magento\Framework\UrlInterface $urlBuilder,
        \Webkul\AdvancedBookingSystem\Helper\Data $helperData
    ) {
        $this->locator = $locator;
        $this->attributeSetCollectionFactory = $attributeSetCollectionFactory;
        $this->urlBuilder = $urlBuilder;
        $this->helperData = $helperData;
    }

    /**
     * After modifyMeta
     *
     * @param ModifierAttributeSet $subject
     * @param mixed $result
     */
    public function afterModifyMeta(ModifierAttributeSet $subject, $result)
    {
        $typeId = $this->locator->getProduct()->getTypeId();
        if ($typeId == "booking" || $typeId == "hotelbooking") {
            $attributeSetIds = $this->helperData->getAllowedAttrSetIDsArray();
            $result['product-details']
                ['children']
                    ['attribute_set_id']
                        ['arguments']
                            ['data']
                                ['config']
                                    ['label'] = __('Booking Type');
                                    
            $result['product-details']
                ['children']
                    ['attribute_set_id']
                        ['arguments']
                            ['data']
                                ['config']
                                    ['options'] = $attributeSetIds;
        }
        return $result;
    }
}
